<%-- Copyright (c) Oracle Corporation 2002. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbumMediaViewer.jsp

    DESCRIPTION
        PhotoAlbumMediaViewer.jsp is one component of a JavaServer Pages
        application that demonstrates the use of interMedia Java Classes for
        Servlets and JSPs by implementing a simple photo album application.
        This page is used to retrieve a full-size or thumbnail image from
        the photo album and deliver it to the browser. This page uses the
        PhotoAlbumBean JavaBean to access the database.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.


                                IMPORTANT
                                =========
            JSP engines are not required to support access to the
            servlet binary output stream. Therefore, not all JSP
            engines support the delivery of multimedia data using
            the OrdHttpJspResponseHandler class. See the Javadoc
            documentation for more detailed information regarding
            the delivery of multimedia data from a JavaServer Page.
--%>

<%@ page language="java" %>
<%@ page import="imjspdemo.PhotoAlbumBean" %>
<%@ page import="oracle.ord.im.OrdHttpJspResponseHandler" %>

<jsp:useBean id="album" scope="page" class="imjspdemo.PhotoAlbumBean"/>
<jsp:useBean id="handler" scope="page"
             class="oracle.ord.im.OrdHttpJspResponseHandler"/>

<%
    //
    // Figure out what to fetch.
    //
    String id = request.getParameter( "id" );
    String media = request.getParameter( "media" );
    if ( id != null || media != null )
    {
        //
        // Use a try block to ensure the JDBC connection is released
        //
        try
        {
            //
            // Select data and fetch the row
            //
            album.selectRowById( id );
            if ( !album.fetch() )
            {
                response.setStatus( response.SC_NOT_FOUND );
                return;
            }

            //
            // Deliver the full-size or thumbnail image
            //
            handler.setPageContext( pageContext );
            if ( media.equals( "image" ) )
            {
                handler.sendImage( album.getImage() );
                return;
            }
            if ( media.equals( "thumb" ) )
            {
                handler.sendImage( album.getThumb() );
                return;
            }
        }
        finally
        {
            //
            // Ensure the JDBC connection is released
            //
            album.release();
        }
    }
%>

<%-- Don't understand the request --%>
<html lang="EN"><head><title>PhotoAlbumMediaViewer.jsp - malformed URL</title></head>
<body><h1>PhotoAlbumMediaViewer.jsp - malformed URL</h1>
</body></html>

